/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Vector;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.FailureDetector;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.MessageQueue;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.ReplyInfo;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;
import oracle.ias.cache.group.ViewInfo;

public class Channel {
    String grpName = null;
    public static final int NORMAL = 0;
    public static final int ATOMIC = 1;
    public static final int TOTAL = 2;
    static byte[] atomic_lock = new byte[0];

    public void close() {
        try {
            if (this.grpName != null) {
                this.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connect(String string) throws GroupException {
        this.grpName = string;
    }

    public void disconnect() throws GroupException {
        this.grpName = null;
    }

    public void send(Object object, Serializable serializable) throws GroupException, IOException {
        this.send(object, serializable, 0L, null, null, 0L);
    }

    public void send(Object object, Serializable serializable, String string) throws GroupException, IOException {
        this.send(object, serializable, 0L, string, null, 0L);
    }

    public void send(Object object, Serializable serializable, InputStream inputStream, long l) throws GroupException, IOException {
        this.send(object, serializable, 0L, null, inputStream, l);
    }

    public void send(Object object, Serializable serializable, long l) throws GroupException, IOException {
        this.send(object, serializable, l, null, null, 0L);
    }

    public void send(Object object, Serializable serializable, long l, String string) throws GroupException, IOException {
        this.send(object, serializable, l, string, null, 0L);
    }

    public void send(Object object, Serializable serializable, long l, InputStream inputStream, long l2) throws GroupException, IOException {
        this.send(object, serializable, l, null, inputStream, l2);
    }

    private void send(Object object, Serializable serializable, long l, String string, InputStream inputStream, long l2) throws GroupException, IOException {
        if (!GroupCommunication.isReady()) {
            throw new GroupException(GroupCommunication.EXP_GRP_NOTINITIALIZED);
        }
        if (GroupCommunication.getMode() != 2 && string != null) {
            throw new GroupException(GroupCommunication.EXP_GRP_WRONG_MODE);
        }
        if (!(object instanceof Address)) {
            throw new GroupException(GroupCommunication.EXP_GRP_INVALIDADDR);
        }
        try {
            Packet packet = new Packet(object, serializable);
            if (l > 0L) {
                packet.setSize(l);
            }
            if (string != null) {
                packet.setAttachedFileName(string);
            }
            if (inputStream != null) {
                packet.setInputStream(inputStream);
                packet.setStreamSize(l2);
            }
            Transport.send(packet);
        }
        catch (GroupException groupException) {
            throw groupException;
        }
        catch (Exception exception) {
            throw new GroupException(GroupCommunication.EXP_GRP_BASE + exception.toString(), exception);
        }
    }

    public ReplyInfo multicast(Serializable serializable) throws GroupException, IOException {
        return this.multicast(serializable, 0);
    }

    public ReplyInfo multicast(Serializable serializable, long l) throws GroupException, IOException {
        return this.multicast(serializable, 0, false, 0L);
    }

    public ReplyInfo multicast(Serializable serializable, int n) throws GroupException, IOException {
        return this.multicast(serializable, n, false, 0L);
    }

    public ReplyInfo multicast(Serializable serializable, int n, long l) throws GroupException, IOException {
        return this.multicast(serializable, n, false, l);
    }

    public ReplyInfo multicast(Serializable serializable, int n, boolean bl) throws GroupException, IOException {
        return this.multicast(serializable, n, bl, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReplyInfo multicast(Serializable serializable, int n, boolean bl, long l) throws GroupException, IOException {
        ReplyInfo replyInfo = null;
        if (!GroupCommunication.isReady()) {
            throw new GroupException(GroupCommunication.EXP_GRP_NOTINITIALIZED);
        }
        if ((n & 2) != 0) {
            n = 2;
        }
        try {
            if ((n & 1) != 0) {
                byte[] byArray = atomic_lock;
                synchronized (atomic_lock) {
                    Packet packet = new Packet(n, this.grpName, serializable);
                    if (bl) {
                        packet.setNodeCast(true);
                    }
                    if (l <= 0L) return Transport.multicast(packet);
                    packet.setSize(l);
                    return Transport.multicast(packet);
                }
            }
            Packet packet = new Packet(n, this.grpName, serializable);
            if (bl) {
                packet.setNodeCast(true);
            }
            if (l > 0L) {
                packet.setSize(l);
            }
            if ((n & 2) == 0) {
                return Transport.multicast(packet);
            }
            if (!Transport.isMyself(FailureDetector.getCoordinator())) return Transport.sendTotalOrderedMsg(packet);
            return Transport.multicastTotalOrderedMsg(packet);
        }
        catch (GroupException groupException) {
            throw groupException;
        }
        catch (Exception exception) {
            throw new GroupException(GroupCommunication.EXP_GRP_BASE + exception.toString(), exception);
        }
    }

    public ReplyInfo nodecast(Serializable serializable) throws GroupException, IOException {
        return this.multicast(serializable, 0, true);
    }

    public ReplyInfo nodecast(Serializable serializable, long l) throws GroupException, IOException {
        return this.multicast(serializable, 0, true, l);
    }

    public ReplyInfo nodecast(Serializable serializable, int n) throws GroupException, IOException {
        return this.multicast(serializable, n, true);
    }

    public ReplyInfo nodecast(Serializable serializable, int n, long l) throws GroupException, IOException {
        return this.multicast(serializable, n, true, l);
    }

    public Object receive(long l) throws GroupException {
        throw new GroupException("Not Implemented Yet.");
    }

    public void registerReceivingQueue(MessageQueue messageQueue) {
        Transport.registerReceivingQueue(this.grpName, messageQueue);
    }

    public void deregisterReceivingQueue(MessageQueue messageQueue) {
        Transport.deregisterReceivingQueue(this.grpName, messageQueue);
    }

    public View getView() throws GroupException {
        View view = null;
        boolean bl = false;
        try {
            GroupManager.getCurrentViewInfoRWLock(this.grpName).acquireReadLock();
            bl = true;
            ViewInfo viewInfo = GroupManager.getCurrentViewInfo(this.grpName);
            view = viewInfo.getView();
        }
        catch (Exception exception) {
            throw new GroupException(GroupCommunication.EXP_GRP_BASE + exception.toString(), exception);
        }
        finally {
            if (bl) {
                GroupManager.releaseCurrentViewLock(this.grpName, true);
            }
        }
        if (view == null) {
            throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL + GroupCommunication.EXP_GRP_VIEWNULL);
        }
        return view;
    }

    public Object getLocalAddress() {
        return Transport.getLocalAddress();
    }

    public int getGlobalPosition() {
        return Transport.getLocalAddress().getPosition();
    }

    public long getUid() {
        return Transport.getLocalAddress().getUid();
    }

    public long getTimeStamp() {
        return Transport.getLocalAddress().getTimeStamp();
    }

    public Object getGroupAddress() throws GroupException {
        if (this.grpName == null) {
            throw new GroupException(GroupCommunication.EXP_GRP_INVALIDCHANNEL);
        }
        return this.grpName;
    }

    public boolean isAlive(long l) {
        return this.isAlive(l, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive(long l, long l2) {
        boolean bl;
        block8: {
            bl = false;
            boolean bl2 = false;
            try {
                GroupManager.getCurrentViewInfoRWLock(this.grpName).acquireReadLock();
                bl2 = true;
                ViewInfo viewInfo = GroupManager.getCurrentViewInfo(this.grpName);
                View view = viewInfo.getView();
                if (view == null) break block8;
                Vector vector = view.getMembers();
                for (int i = 0; i < vector.size(); ++i) {
                    Address address = (Address)vector.elementAt(i);
                    if (address.getUid() != l || address.getTimeStamp() != l2 && l2 != 0L) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                if (GroupCommunication.shouldLog(6)) {
                    GroupCommunication.log("Unable to detect uid: " + l + ". Ingored Exception: ", exception);
                }
            }
            finally {
                if (bl2) {
                    GroupManager.releaseCurrentViewLock(this.grpName, true);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasReceivedAll(long[] lArray) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            GroupManager.getCurrentViewInfoRWLock(this.grpName).acquireReadLock();
            bl2 = true;
            ViewInfo viewInfo = GroupManager.getCurrentViewInfo(this.grpName);
            MessageBuffer messageBuffer = viewInfo.getMessageBuffer();
            if (messageBuffer != null) {
                bl = messageBuffer.hasReceivedAll(lArray);
            }
        }
        catch (Exception exception) {
            if (GroupCommunication.shouldLog(6)) {
                GroupCommunication.log("Ingored Exception: ", exception);
            }
        }
        finally {
            if (bl2) {
                GroupManager.releaseCurrentViewLock(this.grpName, true);
            }
        }
        return bl;
    }
}

